/*
Standard vertex transform shader for static models (no skinning). 
Supports position, normals, uv, tangets, bitangents and color.
Applies mirroring plane to user clip plane 0
*/
#version 430

//Standard vertex attributes, set to the default locations
layout(location = 0) in vec4 in_position;
layout(location = 1) in vec3 in_normal;
layout(location = 2) in vec2 in_uv;
layout(location = 3) in vec3 in_tangent;
layout(location = 4) in vec3 in_bitangent;
layout(location = 5) in vec4 in_color;

//Uniform block for global matrices
#pragma lz append("lzsystem/shaders/generic/globalTransforms.glsl")

//Fragment pass attributes
out VSOut {
	vec4 position_view;
	vec4 position_world;
	vec3 normal;
	vec3 tangent;
	vec3 bitangent;
	vec2 uv;
} vsoutput;

void main() {
	//Standard transform of attributes. 
	vsoutput.normal = mat3(vm) * in_normal;
	vsoutput.tangent = mat3(vm) * in_tangent;
	vsoutput.bitangent = mat3(vm) * in_bitangent;
	vsoutput.uv = in_uv;
	
	vsoutput.position_view = vm * in_position;
	vsoutput.position_world = model * in_position;

	//The distance to the plane, to set the custom clip plane
	gl_ClipDistance[0] = dot(vsoutput.position_world.xyz,mirrorPlane.xyz) + mirrorPlane.w;

	gl_Position = pvm * in_position;

}